
//
// COPYRIGHT (c) SOFTWARE SOURCE 1993
// ALL RIGHTS RESERVED
//
// program - cadd.c
// purpose - CB/ISAM address book sample application.
// author  - Don Wanless
// history - Original 2/15/93
//         - Verbose/pendantic names and comments added by Sam Cohen 2/18/93
//

//
// NOTE: This has been compiled and tested with Microsoft C 6.0, 7.0, and
//       Visual C++.
//

# define CADD_MAIN

# ifndef NOMINMAX
#   define NOMINMAX
# endif // NOMINMAX

# include <windows.h>
# include <stdio.h>
# include <stdlib.h>
# include <string.h>
# include <time.h>
# include <bios.h>
# include <ctype.h>
# include <io.h>
# include <dos.h>

# ifdef DOMX
#   include "cbisammx.h"
# endif // DOMX

# ifdef DOMU
#   include "cbisammu.h"
# endif // DOMU

  // Although this CADD sample app is shipped with both CB/ISAM MX
  // and CB/ISAM MU, it doesn't exploit any of the multi-user
  // capabiilities of CB/ISAM MU... that's left "as an exercise for
  // the student."

# include "cadd.h"
# include "caddg.h"

# ifndef WM_PAINTICON
#   define WM_PAINTICON 0x0026
# endif // WM_PAINTICON

//*******************************************************************
// WinMain - Msgwnd main
//
// parameters:
//             hInstance     - Handle to this instance of this
//                             application.
//             hPrevInstance - Handle to the previous instance
//                             of this application (if any). This will be 0
//                             if this is the first instance.
//             lpszCmdLine   - A long pointer to the command line that
//                             started this application.
//             cmdShow       - Indicates how the window is to be shown
//                             initially -- i.e., SW_SHOWNORMAL, SW_HIDE,
//                             SW_MIMIMIZE.
//
// returns:
//             wParam from last message.
//
//*******************************************************************
int PASCAL WinMain(
    HANDLE  hInstance,
    HANDLE  hPrevInstance,
    LPSTR   lpszCmdLine,
    int     cmdShow)
  {
    HWND    hBrother;
    FARPROC lpAddressProc;

    // see if there is another instance of this app active

    hBrother = FindWindow("#32770", "CADD");

    if (!hBrother)
      {
        // no other instance, so we will start

        hInst = hInstance;       // save for use by window procs

        lpAddressProc = MakeProcInstance((FARPROC) AddressDlg, hInstance);

        if (lpAddressProc)
          {
            DialogBox(hInst,            // This is our main window
                      "ADDRESSBOX",
                      0,
                      lpAddressProc);

            FreeProcInstance(lpAddressProc);
          }
      }
    else
      {
        // another instance is there, so we will transfer control to him

        BringWindowToTop(hBrother);

        if (IsIconic(hBrother))
          {
            ShowWindow(hBrother, SW_SHOWMINIMIZED);
          }
        else
          {
            ShowWindow(hBrother, SW_SHOWNORMAL);
            SendMessage(hBrother, WM_ACTIVATE, 2, NULL);
          }
      }

    // unreferenced formal parms
    hPrevInstance;
    lpszCmdLine;
    cmdShow;

    return(0);
  }

//*******************************************************************

//*******************************************************************
// AddressDlg - handle address box dialog messages
//
// parameters:
//             hDlg          - The window handle for this dialog box
//             message       - The message number
//             wParam        - The WORD parameter for this message
//             lParam        - The LONG parameter for this message
//
// returns:
//             Depends on message.
//
//*******************************************************************
BOOL FAR PASCAL AddressDlg(
    HWND              hDlg,
    WORD              message,
    WORD              wParam,
    LONG              lParam)
  {
    static char       fname[128];
    static char       ini_fname[128];
    static int        nDatasetNumber;
    static MYREC      myrec;
    static char       PrimaryKey[256];
    static HICON      hicon;
    static int        cur_index;

    int               rc;          // return code (from CB/ISAM function calls)
    int               OptionParameter;
    char              LookupKey[256]; // lookup key, also called a "search key"
    char              Throwaway[256];
    char              ReturnCodeTextBuffer[80];
    char              msgbuf[256];
    char              buf[256];
    HDC               hDC;
    PAINTSTRUCT       ps;
    DWORD             n;
    LPSTR             lcp;
    BOOL              fProcessed;

    fProcessed = FALSE;

    switch (message)
      {
        case WM_INITDIALOG:

          // load the icon we will use when iconized

          hicon = LoadIcon(hInst, "CADD");

          // get cadd.exe path and file name so we know where to look for .ini

          GetModuleFileName(hInst, ini_fname, sizeof(ini_fname) - 1);

          lcp = _fstrrchr(ini_fname, '.');
          if (lcp)
            _fstrcpy(lcp, ".INI");
          else
            _fstrcpy(ini_fname, "CADD.INI");

          // note use of .ini file to remember dataset pathname, etc.

          GetPrivateProfileString("cadd",
                                  "AddressFile",
                                  "",
                                  fname,
                                  sizeof(fname),
                                  ini_fname);

          if (!*fname)
            {
              // if we do not find a path\filename, we will make it the
              // path the cadd.exe is on and the base filename of cadd

              GetModuleFileName(hInst, fname, sizeof(fname));
              lcp = _fstrrchr(fname, '.');
              if (lcp)
                *lcp = 0;

              WritePrivateProfileString("cadd",
                                        "AddressFile",
                                        fname,
                                        ini_fname);
            }

          rc = VmxOpen(fname,                  // LPSTR lpFilespec
                       SMALL_CACHE,            // INT   LocatorSize
                       VMODE_RW,               // INT   OpenMode
                       &nDatasetNumber);       // LPINT lpnDatasetNumber

          if (rc == VIS_DOS_ERROR)
            {
              rc = VmxCreate(fname,                // LPSTR lpFilespec
                             myrec_keylen,         // INT   MaxPrimaryKeyLen
                             0L,                   // LONG  GroupSize
                             0,                    // INT   InitAlloc
                             0,                    // INT   IncrAlloc
                             myrec_fmt);           // LPSTR lpFormat

              if (rc == VIS_OK)
                {
                  rc = VmxOpen(fname,                  // LPSTR lpFilespec
                               SMALL_CACHE,            // INT   CacheSize
                               VMODE_RW,               // INT   OpenMode
                               &nDatasetNumber);       // LPINT lpnDatasetNumber
                }
            }

          wsprintf(msgbuf, "OPEN - %s",
                           VmxReturnCode(rc, ReturnCodeTextBuffer));

          SetDlgItemText(hDlg, ID_STATUS, msgbuf);

          // Limit text entry for index fields to max lengths declared
          // in VmxCreate.

          SendDlgItemMessage(hDlg, ID_LAST_NAME,  EM_LIMITTEXT, 30, 0L);
          SendDlgItemMessage(hDlg, ID_FIRST_NAME, EM_LIMITTEXT, 20, 0L);
          SendDlgItemMessage(hDlg, ID_ADDRESS,    EM_LIMITTEXT, 40, 0L);
          SendDlgItemMessage(hDlg, ID_CITY,       EM_LIMITTEXT, 30, 0L);
          SendDlgItemMessage(hDlg, ID_STATE,      EM_LIMITTEXT, 2,  0L);
          SendDlgItemMessage(hDlg, ID_ZIP,        EM_LIMITTEXT, 10, 0L);
          SendDlgItemMessage(hDlg, ID_PHONE,      EM_LIMITTEXT, 20, 0L);

          // restore previous postion of this window (if any)

          set_wnd_pos(hDlg, ini_fname, "cadd", "WindowDlg");

          // set search index to name to start with

          CheckDlgButton(hDlg, ID_SEQ_NAME, 1);

          // post message to read first record in dataset (on name index)

          PostMessage(hDlg, WM_COMMAND, ID_FIRST, 0L);

//-          return(TRUE);

          break;

        case WM_ENDSESSION:

          if (wParam)
            {
              // we will come through here if windows is shutdown while this
              // application is active.

              // we must close the database on exit

              if (nDatasetNumber)
                {
                  rc = VmxClose(nDatasetNumber);            // INT DatasetNumber
                  nDatasetNumber = 0;

                  wsprintf(msgbuf, "CLOSE - %s",
                                   VmxReturnCode(rc, ReturnCodeTextBuffer));

                  SetDlgItemText(hDlg, ID_STATUS, msgbuf);
                }
            }

          break;

        case WM_DESTROY:

          // we will come through here when the user terminates this
          // application.

          // we must close the database on exit

          if (nDatasetNumber)
            {
              rc = VmxClose(nDatasetNumber);            // INT DatasetNumber
              nDatasetNumber = 0;

              wsprintf(msgbuf, "CLOSE - %s",
                               VmxReturnCode(rc, ReturnCodeTextBuffer));

              SetDlgItemText(hDlg, ID_STATUS, msgbuf);
            }

          break;

        case WM_ICONERASEBKGND:
        case WM_ERASEBKGND:

          // so icon will draw with transparent background

          if (IsIconic(hDlg))
            {
              return(TRUE);
            }

          break;

        case WM_PAINT:
        case WM_PAINTICON:

          // since a dialog box is our main window, we must paint our own icon!

          if (IsIconic(hDlg))
            {
              hDC = BeginPaint(hDlg, &ps);
              DrawIcon(hDC, 2, 2, hicon);
              EndPaint(hDlg, &ps);
            }

          break;

        case WM_SYSCOMMAND:

          switch (wParam)
            {
              case SC_CLOSE:

                PostMessage(hDlg, WM_COMMAND, ID_EXIT, 0L);

                break;
            }

          break;

        case WM_COMMAND:

          switch (wParam)
            {
              // See which index to use for browsing and lookups
              // (per radio buttons)

              case ID_SEQ_NAME:
              case ID_SEQ_CITY:
              case ID_SEQ_STATE:
              case ID_SEQ_PHONE:
              case ID_SEQ_ZIP:

                cur_index = get_cur_index(hDlg);

                break;

              case ID_FIRST:

                // User wants to see the first record in the selected index
                // sequence.  First do a VmxBOF call (in that index), then
                // a VmxGet/Next call (in that index).  Note that in this
                // application, we don't provide the user with the ability
                // to select the primary index, because it has no real
                // meaning except as a record identifier.

                cur_index = get_cur_index(hDlg);

                rc = VmxBOF(nDatasetNumber,     // int   DatasetNumber
                            cur_index);         // int   SelectedIndex

                if (rc == VIS_OK)
                  {
                    rc = VmxGet(nDatasetNumber, // int    DatasetNumber  // VIS_BUSY ?
                                cur_index,      // int    SelectedIndex
                                XNEXT   |
                                  XTEXT,        // int    OptionParameter
                                "",             // Don't need a Selector param with these options
                                Throwaway,      // Don't need returned index entry in this case
                                PrimaryKey,     // LPSTR  lpPriKey
                                &myrec,         // LPVOID lpRecordStructure
                                sizeof(myrec)); // size of record structure

                    wsprintf(msgbuf, "GET - %s",
                                     VmxReturnCode(rc, ReturnCodeTextBuffer));

                    SetDlgItemText(hDlg, ID_STATUS, msgbuf);

                    if (!rc)    // note that return code 0 means "OK"
                      {
                        show_record(hDlg,
                                    nDatasetNumber,
                                    PrimaryKey,
                                    &myrec);

                        rc = VmxFreeBuf(&myrec.VBufCB);

                        if (rc != VIS_OK)
                          {
                            wsprintf(msgbuf, "FREEBUF - %s",
                                             VmxReturnCode(rc, ReturnCodeTextBuffer));

                            SetDlgItemText(hDlg, ID_STATUS, msgbuf);
                          }
                      }
                    else if (rc == VIS_NOT_FOUND)
                      {
                        // no records in file so cannot modify or delete

                        PostMessage(hDlg, WM_COMMAND, ID_CLEAR, 0L);
                      }
                  }
                else
                  {
                    wsprintf(msgbuf, "BOF - %s",
                                     VmxReturnCode(rc, ReturnCodeTextBuffer));

                    SetDlgItemText(hDlg, ID_STATUS, msgbuf);
                  }

                break;

              case ID_PREV:

                cur_index = get_cur_index(hDlg);

                rc = VmxGet(nDatasetNumber,          // int    DatasetNumber  // VIS_BUSY ?
                            cur_index,               // int    SelectedIndex
                            XPREVIOUS |
                              XTEXT,                 // int    OptionParameter
                            "",                      // Don't need a Selector param with these options
                            Throwaway,               // Don't need returned index entry in this case
                            PrimaryKey,              // LPSTR  lpPriKey
                            &myrec,                  // LPVOID lpRecordStructure
                            sizeof(myrec));          // size of record structure

                wsprintf(msgbuf, "GET - %s",
                                 VmxReturnCode(rc, ReturnCodeTextBuffer));

                SetDlgItemText(hDlg, ID_STATUS, msgbuf);

                if (rc == VIS_NOT_FOUND)
                  {
                    PostMessage(hDlg, WM_COMMAND, ID_FIRST, 0L);
                  }
                else
                  {
                    show_record(hDlg,
                                nDatasetNumber,
                                PrimaryKey,
                                &myrec);

                    rc = VmxFreeBuf(&myrec.VBufCB);

                    if (rc != VIS_OK)
                      {
                        wsprintf(msgbuf, "FREEBUF - %s",
                                         VmxReturnCode(rc, ReturnCodeTextBuffer));

                        SetDlgItemText(hDlg, ID_STATUS, msgbuf);
                      }
                  }

                break;

              case ID_LOOKUP:

                // The user wants us to find a record whose selected index
                // field is either equal to the "lookup key" (the contents
                // of the text box selected by the radio buttons, OR IS THE
                // NEXT HIGHER_SORTING ENTRY (i.e., equal to or greater than
                // the lookup key).  Note that in case of an exact match in
                // a secondary index in which there are duplicates, CB/ISAM
                // selects the first entry -- i.e., the one whose
                // corresponding primary key is lowest.

                // The plan is to first do a VmxGet/Lookup.  If this matches
                // an index entry, great.  If not, we step forward to the
                // next entry using VmxGet/Next.  (If the lookup took us to
                // EOF -- i.e., beyond the last entry in this index -- we'll
                // just clear the display.)

                cur_index = get_cur_index(hDlg);

                if (cur_index == 1)
                  {
                  // Name.  This is a "constructed" index... we concatenate
                  // lastname and firstname with a binary 2 as a separator
                  // (because that's the lowest-sorting legal char in keys).

                    GetDlgItemText(hDlg, ID_LAST_NAME, LookupKey,  sizeof(LookupKey));
                    _fstrcat(LookupKey, "\002");
                    GetDlgItemText(hDlg, ID_FIRST_NAME, LookupKey + _fstrlen(LookupKey), sizeof(LookupKey) - _fstrlen(LookupKey));
                  }
                else if (cur_index == 5) // city
                  {
                    GetDlgItemText(hDlg, ID_CITY, LookupKey, sizeof(LookupKey));
                  }
                else if (cur_index == 6) // state
                  {
                    GetDlgItemText(hDlg, ID_STATE, LookupKey, sizeof(LookupKey));
                  }
                else if (cur_index == 7) // zip
                  {
                    GetDlgItemText(hDlg, ID_ZIP, LookupKey, sizeof(LookupKey));
                  }
                else if (cur_index == 8) // phone
                  {
                    GetDlgItemText(hDlg, ID_PHONE, LookupKey, sizeof(LookupKey));
                  }

                if (cur_index)
                  {
                    if (!*LookupKey)
                      {
                        // If no lookup key (i.e., the text box is blank),
                        // let's give the user the first entry in the
                        // selected index.

                        PostMessage(hDlg, WM_COMMAND, ID_FIRST, 0L);
                      }
                    else
                      {
                        rc = VmxGet(nDatasetNumber,          // int    DatasetNumber  // VIS_BUSY ?
                                    cur_index,               // int    SelectedIndex
                                    XLOOKUP |
                                      XTEXT,                 // int    OptionParameter
                                    LookupKey,               // LPSTR  lpSelector (now used for lookup)
                                    Throwaway,               // Don't need returned index entry in this case
                                    PrimaryKey,              // LPSTR  lpPriKey
                                    &myrec,                  // LPVOID lpRecordStructure
                                    sizeof(myrec));          // size of record structure

                        wsprintf(msgbuf, "GET - %s",
                                         VmxReturnCode(rc, ReturnCodeTextBuffer));

                        SetDlgItemText(hDlg, ID_STATUS, msgbuf);

                        if (rc == VIS_OK)
                          {
                            show_record(hDlg,
                                        nDatasetNumber,
                                        PrimaryKey,
                                        &myrec);

                            rc = VmxFreeBuf(&myrec.VBufCB);

                            if (rc != VIS_OK)
                              {
                                wsprintf(msgbuf, "FREEBUF - %s",
                                                 VmxReturnCode(rc, ReturnCodeTextBuffer));

                                SetDlgItemText(hDlg, ID_STATUS, msgbuf);
                              }
                          }
                        else if (rc == VIS_NOT_FOUND)
                          {
                            PostMessage(hDlg, WM_COMMAND, ID_NEXT, 1L);
                          }
                      }
                  }

                break;

              case ID_NEXT:

                cur_index = get_cur_index(hDlg);

                rc = VmxGet(nDatasetNumber,          // int    DatasetNumber  // VIS_BUSY ?
                            cur_index,               // int    SelectedIndex
                            XNEXT   |
                              XTEXT,                 // int    OptionParameter
                            "",                      // Don't need a Selector param with these options
                            Throwaway,               // Don't need returned index entry in this case
                            PrimaryKey,              // LPSTR  lpPriKey
                            &myrec,                  // LPVOID lpRecordStructure
                            sizeof(myrec));          // size of record structure

                wsprintf(msgbuf, "GET - %s",
                                 VmxReturnCode(rc, ReturnCodeTextBuffer));

                SetDlgItemText(hDlg, ID_STATUS, msgbuf);

                if (rc == VIS_NOT_FOUND)
                  {
                    if (lParam != 1L)
                      PostMessage(hDlg, WM_COMMAND, ID_LAST, 0L);
                    else

                    // Now we'll get a little cute: if the reason we're here
                    // is that the user pushed the "lookup" button with a
                    // lookup key higher than the last entry in the selected
                    // index, we DON'T want to just give him the last entry,
                    // but instead will do a CLEAR.  For instance, in the
                    // name index, the last name is Watson/James, but the
                    // user did a lookup on "Z".

                    PostMessage(hDlg, WM_COMMAND, ID_CLEAR, 0L);
                  }
                else
                  {
                    show_record(hDlg,
                                nDatasetNumber,
                                PrimaryKey,
                                &myrec);

                    rc = VmxFreeBuf(&myrec.VBufCB);

                    if (rc != VIS_OK)
                      {
                        wsprintf(msgbuf, "FREEBUF - %s",
                                         VmxReturnCode(rc, ReturnCodeTextBuffer));

                        SetDlgItemText(hDlg, ID_STATUS, msgbuf);
                      }
                  }

                break;

              case ID_LAST:

                // Go to EOF in the selected index and then do a VmxGet/Previous.

                cur_index = get_cur_index(hDlg);

                rc = VmxEOF(nDatasetNumber,          // int   DatasetNumber
                            cur_index);              // int   SelectedIndex

                if (rc == VIS_OK)
                  {
                    rc = VmxGet(nDatasetNumber,          // int    DatasetNumber  // VIS_BUSY ?
                                cur_index,               // int    SelectedIndex
                                XPREVIOUS   |
                                  XTEXT,                 // int    OptionParameter
                                "",                      // Don't need a Selector param with these options
                                Throwaway,               // Don't need returned index entry in this case
                                PrimaryKey,              // LPSTR  lpPriKey
                                &myrec,                  // LPVOID lpRecordStructure
                                sizeof(myrec));          // size of record structure

                    wsprintf(msgbuf, "GET - %s",
                                     VmxReturnCode(rc, ReturnCodeTextBuffer));

                    SetDlgItemText(hDlg, ID_STATUS, msgbuf);

                    if (rc == VIS_OK)
                      {
                        show_record(hDlg,
                                    nDatasetNumber,
                                    PrimaryKey,
                                    &myrec);

                        rc = VmxFreeBuf(&myrec.VBufCB);

                        if (rc != VIS_OK)
                          {
                            wsprintf(msgbuf, "FREEBUF - %s",
                                             VmxReturnCode(rc, ReturnCodeTextBuffer));

                            SetDlgItemText(hDlg, ID_STATUS, msgbuf);
                          }
                      }
                    else if (rc == VIS_NOT_FOUND)
                      {
                        // no records in file so cannot modify or delete

                        PostMessage(hDlg, WM_COMMAND, ID_CLEAR, 0L);
                      }
                  }
                else
                  {
                    wsprintf(msgbuf, "EOF - %s",
                                     VmxReturnCode(rc, ReturnCodeTextBuffer));

                    SetDlgItemText(hDlg, ID_STATUS, msgbuf);
                  }

                break;

              case ID_ADDNEW:
              case ID_MODIFY:

                if (wParam == ID_ADDNEW)
                  {
                    OptionParameter = ADD_ONLY;

                    // Since this application's records don't have a
                    // "natural" primary key (i.e., there's no naturally
                    // occurring data that UNIQUELY identifies a record),
                    // we need to make one.  We've chosen to use an
                    // incrementing integer (converted into a string, of
                    // course)... maybe not the best choice, but...  Anyway,
                    // we'll look at the last (highest-sorting) entry in the
                    // primary index and add one to it to make a new primary
                    // key.  In turn, we do that by calling VmxEOF in the
                    // primary index (index 0) and backing up one entry
                    // (VmxGet/Previous).  Note that in the VmxGet/Previous
                    // call, we use the XNO_DATA option, since all we
                    // need is the index entry.

                    rc = VmxEOF(nDatasetNumber,          // int   DatasetNumber
                                0);                      // int   SelectedIndex (Index 0 is the primary index.)

                    if (rc == VIS_OK)
                      {
                        rc = VmxGet(nDatasetNumber,          // int    DatasetNumber  // VIS_BUSY ?
                                    0,                       // int    SelectedIndex
                                    XPREVIOUS   |
                                      XNO_DATA  |
                                      XTEXT,                 // int    OptionParameter
                                    "",                      // Don't need a Selector param with these options
                                    Throwaway,               // Don't need returned index entry in this case
                                    PrimaryKey,              // LPSTR  lpPriKey (This is what we need)
                                    &myrec,                  // LPVOID lpRecordStructure (not affected!)
                                    sizeof(myrec));          // size of record structure

                        wsprintf(msgbuf, "GET - %s",
                                         VmxReturnCode(rc, ReturnCodeTextBuffer));

                        SetDlgItemText(hDlg, ID_STATUS, msgbuf);

                        if (rc == VIS_OK)
                          {
                            // Note: we could have used the "returned index
                            // entry" parameter (the one just prior to
                            // the "returned primary key" parameter) from
                            // this VmxGet; in the primary index, the index
                            // entry IS the primary key (i.e., both
                            // parameters would give you the same value).

                            // Also, remember that moving around in
                            // an index (either the primary index or one of
                            // the secondry indexes) doesn't change your
                            // positioning in the other indexes.

                            n = atol(PrimaryKey);
                            n++;
                          }
                        else if (rc == VIS_NOT_FOUND)
                          {
                            n = 1;
                            rc = VIS_OK;
                          }
                        else
                          {
                            // ??????  (We got sloppy... there should be error handling here.)
                          }

                        if (rc == VIS_OK)
                          {
                            wsprintf(PrimaryKey, "%010ld", n);
                          }
                      }
                    else
                      {
                        wsprintf(msgbuf, "EOF - %s",
                                         VmxReturnCode(rc, ReturnCodeTextBuffer));

                        SetDlgItemText(hDlg, ID_STATUS, msgbuf);
                      }
                  }
                else // wParam == ID_MODIFY
                  {
                    OptionParameter = REPLACE_ONLY;

                    rc = VIS_OK;
                  }

                if (rc == VIS_OK)
                  {
                    rc = build_record(hDlg,
                                      buf,
                                      sizeof(buf),
                                      &myrec);

                    if (!rc)
                      {
                        rc = VmxPut(nDatasetNumber,          // int   DatasetNumber  // VIS_BUSY ?
                                    PrimaryKey,              // LPSTR lpKey
                                    (LPSTR) &myrec,          // LPSTR lpRecordStructure
                                    sizeof(myrec),           // size of myrec
                                    OptionParameter |        // updatemode already set
                                      XTEXT);                // zero  terminated strings (fixed len strings)

                        wsprintf(msgbuf, "%s - %s",
                                         (LPSTR) (wParam == ID_ADDNEW ? "ADD" : "MODIFY"),
                                         VmxReturnCode(rc, ReturnCodeTextBuffer));

                        SetDlgItemText(hDlg, ID_STATUS, msgbuf);

                        if (rc == VIS_OK)
                          {
                            if (wParam == ID_ADDNEW)
                              {
                                SetDlgItemText(hDlg, ID_RECORD_ID, (LPSTR) PrimaryKey);

                                EnableWindow(GetDlgItem(hDlg, ID_MODIFY), TRUE);
                                EnableWindow(GetDlgItem(hDlg, ID_DELETE), TRUE);
                              }
                          }
                      }
                  }

                break;

              case ID_CLEAR:

                clear_display(hDlg);

                SetFocus(GetDlgItem(hDlg, ID_LAST_NAME));

                EnableWindow(GetDlgItem(hDlg, ID_MODIFY), FALSE);
                EnableWindow(GetDlgItem(hDlg, ID_DELETE), FALSE);

                break;

              case ID_DELETE:

                // Note that deletes are done by primary key.  In this app,
                // if the user brings up the display of a valuable record,
                // messes around in the text boxes so he does'nt recognize
                // it anymore, and then pushes the Delete button, guess
                // what happens?

                rc = VmxDelete(nDatasetNumber,       // int   DatasetNumber  // VIS_BUSY ?
                               PrimaryKey);                 // LPSTR lpKey

                wsprintf(msgbuf, "DELETE - %s",
                                 VmxReturnCode(rc, ReturnCodeTextBuffer));

                SetDlgItemText(hDlg, ID_STATUS, msgbuf);

                PostMessage(hDlg, WM_COMMAND, ID_NEXT, 0L);

                break;

              case ID_EXIT:

                save_wnd_pos(hDlg, ini_fname, "cadd", "WindowDlg");

                EndDialog(hDlg, TRUE);

                break;

//              case ID_LAST_NAME:
//              case ID_FIRST_NAME:
//              case ID_ADDRESS:
//              case ID_CITY:
//              case ID_STATE:
//              case ID_ZIP:
//              case ID_PHONE:
//
//                break;

              default:

//-                fProcessed = TRUE;

                break;
            }

          break;

        default:

//-          fProcessed = TRUE;

          break;
      }

    return(fProcessed);
  }

//*******************************************************************

//*******************************************************************
// show_record - take data from record and show in dialog box
//
//*******************************************************************
void show_record(
    HWND    hDlg,
    int     nDatasetNumber,
    LPSTR   lpkey,
    LPMYREC lpmyrec)
  {
    //
    // copy data from record struct into dialog box fields
    //

    SetDlgItemText(hDlg, ID_RECORD_ID,  lpkey);

    SetDlgItemText(hDlg, ID_LAST_NAME,  lpmyrec->lastname);
    SetDlgItemText(hDlg, ID_FIRST_NAME, lpmyrec->firstname);
    SetDlgItemText(hDlg, ID_ADDRESS,    lpmyrec->address);
    SetDlgItemText(hDlg, ID_CITY,       lpmyrec->city);
    SetDlgItemText(hDlg, ID_STATE,      lpmyrec->state);
    SetDlgItemText(hDlg, ID_ZIP,        lpmyrec->zip);
    SetDlgItemText(hDlg, ID_PHONE,      lpmyrec->phone);

    SetDlgItemText(hDlg, ID_NOTEBOX,    lpmyrec->notes.lpData);

    EnableWindow(GetDlgItem(hDlg, ID_MODIFY), TRUE);
    EnableWindow(GetDlgItem(hDlg, ID_DELETE), TRUE);

    // unreferenced formal parms
    nDatasetNumber;
  }

//*******************************************************************
// build_record - take data from dialog box and put into record struct
//
//*******************************************************************
int build_record(
    HWND    hDlg,
    LPSTR   buf,
    WORD    lbuf,
    LPMYREC lpmyrec)
  {
    int     rc;

    //
    // copy data from dialog box fields into record structure
    //

    GetDlgItemText(hDlg, ID_LAST_NAME,  lpmyrec->lastname,  sizeof(lpmyrec->lastname));
    GetDlgItemText(hDlg, ID_FIRST_NAME, lpmyrec->firstname, sizeof(lpmyrec->firstname));
    GetDlgItemText(hDlg, ID_ADDRESS,    lpmyrec->address,   sizeof(lpmyrec->address));
    GetDlgItemText(hDlg, ID_CITY,       lpmyrec->city,      sizeof(lpmyrec->city));
    GetDlgItemText(hDlg, ID_STATE,      lpmyrec->state,     sizeof(lpmyrec->state));
    GetDlgItemText(hDlg, ID_ZIP,        lpmyrec->zip,       sizeof(lpmyrec->zip));
    GetDlgItemText(hDlg, ID_PHONE,      lpmyrec->phone,     sizeof(lpmyrec->phone));

    GetDlgItemText(hDlg, ID_NOTEBOX,    buf,                lbuf);
    lpmyrec->notes.nLen = _fstrlen(buf);
    lpmyrec->notes.lpData = (LPSTR) buf;

    // We construct the "name" index field by concatenating lastname, binary
    // 2, and firstname.  Binary 2  (control-B) is the lowest-sorting
    // character legal for use in keys.
    _fstrcpy(lpmyrec->name, lpmyrec->lastname);
    _fstrcat(lpmyrec->name, "\002");
    _fstrcat(lpmyrec->name, lpmyrec->firstname);

    if (*lpmyrec->lastname || *lpmyrec->firstname)
      rc = 0;
    else
      rc = 1;

    return(rc);
  }

//*******************************************************************
// clear_display - clear dialog box
//
//*******************************************************************
void clear_display(
    HWND    hDlg)
  {
    //
    // clear dialog box fields
    //

    SetDlgItemText(hDlg, ID_RECORD_ID,  "");

    SetDlgItemText(hDlg, ID_LAST_NAME,  "");
    SetDlgItemText(hDlg, ID_FIRST_NAME, "");
    SetDlgItemText(hDlg, ID_ADDRESS,    "");
    SetDlgItemText(hDlg, ID_CITY,       "");
    SetDlgItemText(hDlg, ID_STATE,      "");
    SetDlgItemText(hDlg, ID_ZIP,        "");
    SetDlgItemText(hDlg, ID_PHONE,      "");
    SetDlgItemText(hDlg, ID_NOTEBOX,    "");
  }

//*******************************************************************
// get_cur_index - find currently selected index
//
//*******************************************************************
int get_cur_index(
    HWND       hDlg)
  {
    static int prev_index;

    int        cur_index;
    char       buf[80];

    if (IsDlgButtonChecked(hDlg, ID_SEQ_NAME))
      cur_index = 1; // name xref
    else if (IsDlgButtonChecked(hDlg, ID_SEQ_CITY))
      cur_index = 5; // city xref
    else if (IsDlgButtonChecked(hDlg, ID_SEQ_STATE))
      cur_index = 6; // state xref
    else if (IsDlgButtonChecked(hDlg, ID_SEQ_ZIP))
      cur_index = 7; // zip xref
    else if (IsDlgButtonChecked(hDlg, ID_SEQ_PHONE))
      cur_index = 8; // phone xref
    else
      cur_index = 0; // error

    if (cur_index != prev_index)
      {
        prev_index = cur_index;

        _fstrcpy(buf, "Key Sequence: ");

        switch (cur_index)
          {
            case 1:
              _fstrcat(buf, "Name");
              break;

            case 5:
              _fstrcat(buf, "City");
              break;

            case 6:
              _fstrcat(buf, "State");
              break;

            case 7:
              _fstrcat(buf, "Zip");
              break;

            case 8:
              _fstrcat(buf, "Phone");
              break;
          }

        SetDlgItemText(hDlg, ID_SEQ, (LPSTR) buf);
      }

    return(cur_index);
  }

//*******************************************************************

//*******************************************************************
// save_wnd_pos - save current position of a window
//
//*******************************************************************
void save_wnd_pos(
    HWND     hWnd,
    LPSTR    szIniFileName,
    LPSTR    szIniSectionName,
    LPSTR    szIniParmName)
  {
    RECT     wrect;
    char     szWinLocStr[40];
    int      w, h;

    GetWindowRect(hWnd, (LPRECT) &wrect);

    w = wrect.right - wrect.left;
    h = wrect.bottom - wrect.top;

    if (w > 32) // do not save if window is an icon
      {
        // Make a string with our window location and size.
        wsprintf(szWinLocStr, "%d,%d,%d,%d", wrect.left, wrect.top, w, h);

        // Save in .INI file.
        WritePrivateProfileString(szIniSectionName,
                                  szIniParmName,
                                  szWinLocStr,
                                  szIniFileName);
      }
  }

//*******************************************************************
// set_wnd_pos - move a window to a saved positon
//
//*******************************************************************
void set_wnd_pos(
    HWND     hWnd,
    LPSTR    szIniFileName,
    LPSTR    szIniSectionName,
    LPSTR    szIniParmName)
  {
    char     szWinLocStr[40];
    int      x, y, w, h;
    char    *cp;

    GetPrivateProfileString(szIniSectionName,
                            szIniParmName,
                            "",
                            szWinLocStr,
                            sizeof(szWinLocStr),
                            szIniFileName);

    if (*szWinLocStr)
      {
        cp = szWinLocStr;
        x = (int) strtol(cp, &cp, 10);

        cp++;
        y = (int) strtol(cp, &cp, 10);

        cp++;
        w = (int) strtol(cp, &cp, 10);

        cp++;
        h = (int) strtol(cp, &cp, 10);

        MoveWindow(hWnd, x, y, w, h, TRUE);
      }
  }

//*******************************************************************
